/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.editor.FmtFieldTriadSpec;
import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueListener;
import com.quantumdata.fmteditor.fmtwidgets.FmtNumericField;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class FmtFieldTriad {
    protected FmtFieldTriadSpec m_spec = new FmtFieldTriadSpec(3);
    protected boolean m_enabled = true;
    protected Color m_selColor;
    protected Color m_notSelColor;

    public FmtFieldTriad(FmtFieldTriadSpec fmtFieldTriadSpec) {
        this.m_spec.copy(fmtFieldTriadSpec);
        this.m_selColor = new Color(128, 0, 0);
        this.m_notSelColor = new Color(0, 128, 0);
        if (this.m_spec.mode == 1) {
            Color color = this.m_selColor;
            this.m_selColor = this.m_notSelColor;
            this.m_notSelColor = color;
        }
        for (int i = 0; i < this.m_spec.fields.length; ++i) {
            if (i < 3) {
                this.m_spec.fields[i].getValue().addListener(new FieldListener(i));
                this.m_spec.selectors[i].addActionListener(new SelectListener(i));
            }
            this.m_spec.fields[i].setForeground(Color.white);
            this.m_spec.fields[i].setFocusable(true);
        }
    }

    protected void init(int n) {
        this.select(n);
        if (this.m_spec.mode != 1) {
            ++n;
            n %= 3;
        }
        this.valueChanged(n);
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
        if (this.m_enabled) {
            this.select(this.getSelectedId());
        } else {
            for (FmtNumericField fmtNumericField : this.m_spec.fields) {
                fmtNumericField.setEditable(false);
                fmtNumericField.setBackground(Color.darkGray);
            }
        }
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    protected abstract void valueChanged(int var1);

    protected CmdValue getValue(int n) {
        if (n < 0 || n >= this.m_spec.fields.length) {
            return null;
        }
        return this.m_spec.fields[n].getValue();
    }

    protected FmtNumericField getField(int n) {
        if (n < 0 || n >= this.m_spec.fields.length) {
            return null;
        }
        return this.m_spec.fields[n];
    }

    protected void select(int n) {
        if (n < 0 || n >= 3) {
            return;
        }
        boolean bl = this.m_spec.mode == 1;
        for (int i = 0; i < 3; ++i) {
            this.m_spec.selectors[i].setSelected(i == n ? bl : !bl);
            if (!this.m_enabled) continue;
            this.m_spec.fields[i].setEditable(i == n ? bl : !bl);
            this.m_spec.fields[i].setBackground(i == n ? this.m_selColor : this.m_notSelColor);
            this.m_spec.fields[i].setFocusable(i == n ? bl : !bl);
            this.m_spec.selectors[i].setEnabled(i != n);
        }
    }

    protected boolean isSelected(int n) {
        if (n < 0 || n >= 3) {
            return false;
        }
        boolean bl = this.m_spec.mode == 1;
        return this.m_spec.selectors[n].isSelected() == bl;
    }

    protected int getSelectedId() {
        boolean bl = this.m_spec.mode == 1;
        for (int i = 0; i < 3; ++i) {
            if (this.m_spec.selectors[i].isSelected() != bl) continue;
            return i;
        }
        return -1;
    }

    private class SelectListener
    implements ActionListener {
        private int m_selId;

        public SelectListener(int n) {
            this.m_selId = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FmtFieldTriad.this.select(this.m_selId);
        }
    }

    private class FieldListener
    implements CmdValueListener {
        private int m_fieldId;

        public FieldListener(int n) {
            this.m_fieldId = n;
        }

        public void valueChanged(CmdValue cmdValue) {
            FmtFieldTriad.this.valueChanged(this.m_fieldId);
        }
    }
}

